<?php defined('CORE_DIR') || exit('入口错误'); ?>
<?php
class ctl_passport extends adminPage{
    var $login_times_error=3;
    function login(){
        $this->pagedata['message'] = $_SESSION['loginmsg'];
        unset($_SESSION['loginmsg']);
        $this->pagedata['show_varycode']=$this->checkVeryCode();
        $this->system->__session_close();
        if($_COOKIE["SHOPEX_LOGIN_NAME"]){
            $this->pagedata['username']=$_COOKIE["SHOPEX_LOGIN_NAME"];
            $this->pagedata['save_login_name']=true;
        }
        $auth_type = $this->system->getConf('certificate.auth_type');
        $auth_code = $this->system->getConf('certificate.auth_code');
        $certificate = $this->system->loadModel('service/certificate');
       
        if ( 'F' == $auth_code ){  // 终身授权
            $this->pagedata['authcode'] = $auth_code;
            $this->pagedata['authstate'] = $certificate->getUrl($this->system->getConf('certificate.auth_strname'),'single');            
            
        }else{ //非终身授权 包含绿卡和未授权
            
            if('Q' == $auth_code){  //绿卡授权
                $this->pagedata['authcode'] = $auth_code;
                $this->pagedata['authstate'] = $certificate->getUrl($this->system->getConf('certificate.auth_strname'),'single');                
            }else{
                $this->pagedata['authcode'] = $auth_code;
                if( $this->system->getConf('certificate.auth_strname') ){
                    $this->pagedata['authstate'] = $certificate->getUrl($this->system->getConf('certificate.auth_strname'),'single');
                }else{
                    $this->pagedata['authstate'] = $certificate->getUrl('未授权用户','single');
                }  
                $this->pagedata['noauthorize'] = $certificate->getUrl('立即激活正版终身商业授权','active');             
            } 
        }
        if($_GET['return']) $this->pagedata['return'] = htmlspecialchars($_GET['return']);
        if('ZFZ'==$this->system->getConf('system.b2c_shop_type')){
            $shop_type[]=array('text'=>'零售店后台管理','from_action'=>$this->system->base_url());
            $shop_type[]=array('text'=>'批发店后台管理','from_action'=>$this->system->getConf('system.b2b_shop_url'));
            $this->pagedata['shop_type'] = $shop_type;
            $this->display('login_zfz.html');
        }else{
            $this->display('login.html');
        }
    }
    function checkVeryCode()
    {
        if($this->system->getConf('system.admin_verycode') || ($this->system->getConf('system.admin_error_login_times')>$this->login_times_error && intval($this->system->getConf('system.admin_error_login_time')+3600)>time())){
            return true;
        }else{
            return false;
        }
    }
    function dologin(){
        if($this->system->getConf('system.admin_verycode') || $this->system->getConf('system.admin_error_login_times')>$this->login_times_error){
            if(strtolower($_POST["verifycode"]) !== strtolower($_SESSION["RANDOM_CODE"]))
            {
                $_SESSION['loginmsg'] = __("验证码输入错误!");
                header('Location: index.php?ctl=passport&act=login');
                exit;
            }
        }
        
        $oOpt = &$this->system->loadModel('admin/operator');
        $aResult = $oOpt->tryLogin($_POST);
        if ($aResult){
            require('magicvars_sys.php');

            $magic = &$this->system->loadModel('system/magicvars');
            $now_magic_data = $magic->getList('var_name','',0,-1);
            $tmp_magic_data = array();
            foreach($now_magic_data as $m_key =>$m_value){
                $tmp_magic_data[$m_value['var_name']]  = 1;
            }
            $import_data = array_diff_key($magicvars,$tmp_magic_data);
            if($import_data){
                foreach($import_data as $me=>$i_data){
                        $magic->insert($i_data);
                }
            }
            if($_POST['save_login_name']){
                setcookie("SHOPEX_LOGIN_NAME",$_POST['usrname'],(time()+86400*10));
            }else{
                setcookie("SHOPEX_LOGIN_NAME","");
            }

            $log_info['username'] = $_POST['usrname'];
            $oOpt->operator_logs('operator',$log_info);

            $status = &$this->system->loadModel('system/status');
            $lg_key = $this->system->getConf('system.admin_dontlogincheckip') ? md5(remote_addr().$aResult['op_id']) :md5($aResult['op_id']);
            $_SESSION['SHOPEX_LG_KEY'] = $lg_key;
            setcookie('SHOPEX_LG_KEY', $lg_key);
            $status->update(1);
            $this->system->op_id = $aResult['op_id'];
            $data['lastlogin']=time();
            $data['logincount'] = $aResult['logincount'] + 1;
            $oOpt->setLogInfo($data,$aResult['op_id']);
            $this->system->setConf('system.admin_error_login_times',0);
            if($_REQUEST['return'] && (false !== strpos($_REQUEST['return'],$this->system->base_url())) ){
                header("Location: index.php#".$_REQUEST['return']);
            }else{
                header("Location: index.php");
            }

        }else{
            if(intval($this->system->getConf('system.admin_error_login_time')+3600)>time()){
                $this->system->setConf('system.admin_error_login_times',$this->system->getConf('system.admin_error_login_times')+1);
            }else{

                $this->system->setConf('system.admin_error_login_times',1);
            }
            $this->system->setConf('system.admin_error_login_time',time());
            $_SESSION['loginmsg'] = __('用户名或密码错误!');
            header('Location: index.php?ctl=passport&act=login');
            exit;
        }
    }

    function check_login(){
        $oOpt = &$this->system->loadModel('admin/operator');
        $aResult = $oOpt->doLogin($_POST);
        if($aResult){
            echo 'true';
            exit;
        }else{
            echo 'false';
            exit;
        }
    }

    function logout(){
        $this->system->op_id = 0;
        $_SESSION = array();
        header('Location: index.php?ctl=passport&act=login');
    }

    function verifycode(){
        ob_clean();
        
        $oVerifyCode = &$this->system->loadmodel('utility/vcode');
        $_SESSION["RANDOM_CODE"] = $oVerifyCode->init(4);
        $this->system->__session_close(1);
        $oVerifyCode->output();
    }

    function certi_validate(){
        $return = array(
            'res' => 'succ','msg' => '','info' => ''
        );

        echo json_encode($return);
    }

    function step_complete(){
        $admin_url = $this->system->base_url().SHOPADMIN_PATH;

        $this->pagedata['shop_url']=  $this->system->base_url(); 
        $this->pagedata['shopadmin_url']= $admin_url;
        $this->pagedata['password'] = $_POST['password'];
        $this->pagedata['uname'] = $_POST['uname']?$_POST['uname']:'admin';
        $this->output_('step/step_install_complete.html');
    }
    
    function step_active(){
        if($this->system->getConf('enterprise.ent_id')){
            $this->login();exit;
        }
        $certi_model = &$this->system->loadModel('service/certificate');

        $admin_url = $this->system->base_url().SHOPADMIN_PATH;

        $params = array(           
            'callback' => urlencode($admin_url)
        );

        if( !$certi_model->getoauth_token() ) {            
            $this->pagedata['link_url'] = urlencode($admin_url);
            $this->pagedata['ac'] = $certi_model->make_shopex_ac($params,ACTIVE_OAUTH_KEY);
            $this->output_('step/step_active.html');
        }else{
            echo "<script>parent.location.reload();</script>";
            //header('Location:'.$admin_url);
            
        }
    }

    function output_($file){
        header('Content-type: text/html;charset=utf-8');
        $this->pagedata['PAGE'] = $file;
        $this->pagedata['version'] = $this->system->loadModel('service/certificate')->getVersion();
        
        $smarty = &$this->system->loadModel('system/frontend');
        $smarty->ctl = &$this;
        $smarty->force_compile = true;
        $smarty->template_dir = CORE_DIR.'admin/view/step';
        $smarty->_vars = &$this->pagedata;
        $smarty->display('step/main.html');
        exit();
    }
}
